#include "mpi.h"
#include <stdio.h>
#include <stdlib.h>
// prime 
#define MASTER 0
#define DISPLAY 1

int is_prime(int n) {
    if (n < 2) return 0;
    if (n == 2 || n == 3) return 1;
    if (n % 2 == 0 || n % 3 == 0) return 0;
    for (int i = 5; i * i <= n; i += 6)
        if (n % i == 0 || n % (i + 2) == 0) return 0;
    return 1;
}

int main(int argc, char *argv[]) {
    MPI_Init(&argc, &argv);
    
    int procs, rank;
    MPI_Comm_size(MPI_COMM_WORLD, &procs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    int N = 0;
    int *vector = NULL;

    if (rank == MASTER) {
        if (argc < 3) {
            fprintf(stderr, "Usage: mpirun -np P %s N n1 n2 ... nN\n", argv[0]);
            MPI_Abort(MPI_COMM_WORLD, 1);
        }
        N = atoi(argv[1]);
        vector = malloc(N * sizeof(int));
        for (int i = 0; i < N; i++)
            vector[i] = atoi(argv[2 + i]);
    }

    MPI_Bcast(&N, 1, MPI_INT, MASTER, MPI_COMM_WORLD);

    if (rank != MASTER) vector = malloc(N * sizeof(int));

    MPI_Bcast(vector, N, MPI_INT, MASTER, MPI_COMM_WORLD);

    int start = rank * N / procs;
    int end = (rank + 1) * N / procs;

    int local_count = 0, local_sum = 0;
    for (int i = start; i < end; i++) {
        if (is_prime(vector[i])) {
            local_count++;
            local_sum += i;
        }
    }

    int total_count = 0, total_sum = 0;
    MPI_Reduce(&local_count, &total_count, 1, MPI_INT, MPI_SUM, DISPLAY, MPI_COMM_WORLD);
    MPI_Reduce(&local_sum, &total_sum, 1, MPI_INT, MPI_SUM, DISPLAY, MPI_COMM_WORLD);

    if (rank == DISPLAY) printf("%d %d\n", total_count, total_sum);

    free(vector);
    MPI_Finalize();
    return 0;
}
